import { Component, OnInit } from '@angular/core';
import { ServicesService } from '../services.service';
import { Clients } from '../interfaces';
import { NgForm} from '@angular/forms';

@Component({
  selector: 'app-client',
  templateUrl: './client.component.html',
  styleUrl: './client.component.css'
})
export class ClientComponent implements OnInit {

  client: any;

  parseInfo: any;

  clients: any;

  code : number = 0;

  reponse : string = "";

  isDisplayed = true;

  showMe()
    {
        if(this.isDisplayed)
        {
            this.isDisplayed = false;

            this.reponse = "";

        }else{

            this.isDisplayed = true;

            this.reponse = "";
        }
    }


  constructor(private clientService: ServicesService) { }

  ngOnInit() {
    
      this.clientService.recuperePlusieurs().subscribe(clients => {
      
      this.client = JSON.stringify(clients);

      this.parseInfo = JSON.parse(this.client);

      this.clients = this.parseInfo['client'];
      
      //this.taille = Object.keys(this.apps).length;
      
    });
    
  }

  ajouter(f: NgForm){

    this.clientService.ajoutUn(f.value).subscribe(client => {

      this.code = client.code;

      if(this.code == 201){

        this.reponse = " : Client ajouté";
        
        this.clientService.recuperePlusieurs().subscribe(clients => {
      
          this.client = JSON.stringify(clients);
    
          this.parseInfo = JSON.parse(this.client);
    
          this.clients = this.parseInfo['client'];
          
          //this.taille = Object.keys(this.apps).length;
          
        });

        f.resetForm(); 

        this.isDisplayed = true;

        

      }
      else{
        
        this.reponse = ": Le client n'est pas ajouté";

      }

      

    } )

  }

}

