/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Re-export TransferState to the public API of the `platform-browser` for backwards-compatibility.
import { makeStateKey as makeStateKeyFromCore, TransferState as TransferStateFromCore } from '@angular/core';
/**
 * Create a `StateKey<T>` that can be used to store value of type T with `TransferState`.
 *
 * Example:
 *
 * ```
 * const COUNTER_KEY = makeStateKey<number>('counter');
 * let value = 10;
 *
 * transferState.set(COUNTER_KEY, value);
 * ```
 *
 * @publicApi
 * @deprecated `makeStateKey` has moved, please import `makeStateKey` from `@angular/core` instead.
 */
// The below is a workaround to add a deprecated message.
export const makeStateKey = makeStateKeyFromCore;
// The below type is needed for G3 due to JSC_CONFORMANCE_VIOLATION.
export const TransferState = TransferStateFromCore;
export { bootstrapApplication, BrowserModule, createApplication, platformBrowser, provideProtractorTestingSupport } from './browser';
export { Meta } from './browser/meta';
export { Title } from './browser/title';
export { disableDebugTools, enableDebugTools } from './browser/tools/tools';
export { By } from './dom/debug/by';
export { REMOVE_STYLES_ON_COMPONENT_DESTROY } from './dom/dom_renderer';
export { EVENT_MANAGER_PLUGINS, EventManager, EventManagerPlugin } from './dom/events/event_manager';
export { HAMMER_GESTURE_CONFIG, HAMMER_LOADER, HammerGestureConfig, HammerModule } from './dom/events/hammer_gestures';
export { DomSanitizer } from './security/dom_sanitization_service';
export { provideClientHydration, withHttpTransferCacheOptions, withNoHttpTransferCache } from './hydration';
export * from './private_export';
export { VERSION } from './version';
//# sourceMappingURL=data:application/json;base64,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