/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/** Whether test modules should be torn down by default. */
export const TEARDOWN_TESTING_MODULE_ON_DESTROY_DEFAULT = true;
/** Whether unknown elements in templates should throw by default. */
export const THROW_ON_UNKNOWN_ELEMENTS_DEFAULT = false;
/** Whether unknown properties in templates should throw by default. */
export const THROW_ON_UNKNOWN_PROPERTIES_DEFAULT = false;
/**
 * An abstract class for inserting the root test component element in a platform independent way.
 *
 * @publicApi
 */
export class TestComponentRenderer {
    insertRootElement(rootElementId) { }
    removeAllRootElements() { }
}
/**
 * @publicApi
 */
export const ComponentFixtureAutoDetect = new InjectionToken('ComponentFixtureAutoDetect');
/**
 * @publicApi
 */
export const ComponentFixtureNoNgZone = new InjectionToken('ComponentFixtureNoNgZone');
//# sourceMappingURL=data:application/json;base64,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