/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as o from '../../../output/output_ast';
import * as ir from '../ir';
export const BINARY_OPERATORS = new Map([
    ['&&', o.BinaryOperator.And],
    ['>', o.BinaryOperator.Bigger],
    ['>=', o.BinaryOperator.BiggerEquals],
    ['&', o.BinaryOperator.BitwiseAnd],
    ['/', o.BinaryOperator.Divide],
    ['==', o.BinaryOperator.Equals],
    ['===', o.BinaryOperator.Identical],
    ['<', o.BinaryOperator.Lower],
    ['<=', o.BinaryOperator.LowerEquals],
    ['-', o.BinaryOperator.Minus],
    ['%', o.BinaryOperator.Modulo],
    ['*', o.BinaryOperator.Multiply],
    ['!=', o.BinaryOperator.NotEquals],
    ['!==', o.BinaryOperator.NotIdentical],
    ['??', o.BinaryOperator.NullishCoalesce],
    ['||', o.BinaryOperator.Or],
    ['+', o.BinaryOperator.Plus],
]);
export function namespaceForKey(namespacePrefixKey) {
    const NAMESPACES = new Map([['svg', ir.Namespace.SVG], ['math', ir.Namespace.Math]]);
    if (namespacePrefixKey === null) {
        return ir.Namespace.HTML;
    }
    return NAMESPACES.get(namespacePrefixKey) ?? ir.Namespace.HTML;
}
export function keyForNamespace(namespace) {
    const NAMESPACES = new Map([['svg', ir.Namespace.SVG], ['math', ir.Namespace.Math]]);
    for (const [k, n] of NAMESPACES.entries()) {
        if (n === namespace) {
            return k;
        }
    }
    return null; // No namespace prefix for HTML
}
export function prefixWithNamespace(strippedTag, namespace) {
    if (namespace === ir.Namespace.HTML) {
        return strippedTag;
    }
    return `:${keyForNamespace(namespace)}:${strippedTag}`;
}
export function literalOrArrayLiteral(value) {
    if (Array.isArray(value)) {
        return o.literalArr(value.map(literalOrArrayLiteral));
    }
    return o.literal(value);
}
//# sourceMappingURL=data:application/json;base64,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