/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Marker symbol for `ConsumesSlotOpTrait`.
 */
export const ConsumesSlot = Symbol('ConsumesSlot');
/**
 * Marker symbol for `DependsOnSlotContextOpTrait`.
 */
export const DependsOnSlotContext = Symbol('DependsOnSlotContext');
/**
 * Marker symbol for `ConsumesVars` trait.
 */
export const ConsumesVarsTrait = Symbol('ConsumesVars');
/**
 * Marker symbol for `UsesVarOffset` trait.
 */
export const UsesVarOffset = Symbol('UsesVarOffset');
/**
 * Default values for most `ConsumesSlotOpTrait` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_SLOT = {
    [ConsumesSlot]: true,
    numSlotsUsed: 1,
};
/**
 * Default values for most `DependsOnSlotContextOpTrait` fields (used with the spread operator to
 * initialize implementors of the trait).
 */
export const TRAIT_DEPENDS_ON_SLOT_CONTEXT = {
    [DependsOnSlotContext]: true,
};
/**
 * Default values for `UsesVars` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_VARS = {
    [ConsumesVarsTrait]: true,
};
/**
 * Default values for `UsesVarOffset` fields (used with the spread operator to initialize
 * implementors of this trait).
 */
export const TRAIT_USES_VAR_OFFSET = {
    [UsesVarOffset]: true,
    varOffset: null,
};
/**
 * Test whether an operation implements `ConsumesSlotOpTrait`.
 */
export function hasConsumesSlotTrait(op) {
    return op[ConsumesSlot] === true;
}
/**
 * Test whether an operation implements `DependsOnSlotContextOpTrait`.
 */
export function hasDependsOnSlotContextTrait(op) {
    return op[DependsOnSlotContext] === true;
}
export function hasConsumesVarsTrait(value) {
    return value[ConsumesVarsTrait] === true;
}
/**
 * Test whether an expression implements `UsesVarOffsetTrait`.
 */
export function hasUsesVarOffsetTrait(expr) {
    return expr[UsesVarOffset] === true;
}
//# sourceMappingURL=data:application/json;base64,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