/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { createEngine as ɵcreateEngine } from './create_engine';
export { Animation as ɵAnimation } from './dsl/animation';
export { AnimationStyleNormalizer as ɵAnimationStyleNormalizer, NoopAnimationStyleNormalizer as ɵNoopAnimationStyleNormalizer } from './dsl/style_normalization/animation_style_normalizer';
export { WebAnimationsStyleNormalizer as ɵWebAnimationsStyleNormalizer } from './dsl/style_normalization/web_animations_style_normalizer';
export { AnimationEngine as ɵAnimationEngine } from './render/animation_engine_next';
export { AnimationRendererFactory as ɵAnimationRendererFactory } from './render/animation_renderer';
export { AnimationRenderer as ɵAnimationRenderer, BaseAnimationRenderer as ɵBaseAnimationRenderer } from './render/renderer';
export { containsElement as ɵcontainsElement, getParentElement as ɵgetParentElement, invokeQuery as ɵinvokeQuery, validateStyleProperty as ɵvalidateStyleProperty, validateWebAnimatableStyleProperty as ɵvalidateWebAnimatableStyleProperty } from './render/shared';
export { WebAnimationsDriver as ɵWebAnimationsDriver } from './render/web_animations/web_animations_driver';
export { WebAnimationsPlayer as ɵWebAnimationsPlayer } from './render/web_animations/web_animations_player';
export { allowPreviousPlayerStylesMerge as ɵallowPreviousPlayerStylesMerge, camelCaseToDashCase as ɵcamelCaseToDashCase, normalizeKeyframes as ɵnormalizeKeyframes } from './util';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJpdmF0ZV9leHBvcnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9hbmltYXRpb25zL2Jyb3dzZXIvc3JjL3ByaXZhdGVfZXhwb3J0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUNILE9BQU8sRUFBQyxZQUFZLElBQUksYUFBYSxFQUFDLE1BQU0saUJBQWlCLENBQUM7QUFDOUQsT0FBTyxFQUFDLFNBQVMsSUFBSSxVQUFVLEVBQUMsTUFBTSxpQkFBaUIsQ0FBQztBQUN4RCxPQUFPLEVBQUMsd0JBQXdCLElBQUkseUJBQXlCLEVBQUUsNEJBQTRCLElBQUksNkJBQTZCLEVBQUMsTUFBTSxzREFBc0QsQ0FBQztBQUMxTCxPQUFPLEVBQUMsNEJBQTRCLElBQUksNkJBQTZCLEVBQUMsTUFBTSwyREFBMkQsQ0FBQztBQUN4SSxPQUFPLEVBQUMsZUFBZSxJQUFJLGdCQUFnQixFQUFDLE1BQU0sZ0NBQWdDLENBQUM7QUFDbkYsT0FBTyxFQUFDLHdCQUF3QixJQUFJLHlCQUF5QixFQUFDLE1BQU0sNkJBQTZCLENBQUM7QUFDbEcsT0FBTyxFQUFDLGlCQUFpQixJQUFJLGtCQUFrQixFQUFFLHFCQUFxQixJQUFJLHNCQUFzQixFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFDM0gsT0FBTyxFQUFDLGVBQWUsSUFBSSxnQkFBZ0IsRUFBRSxnQkFBZ0IsSUFBSSxpQkFBaUIsRUFBRSxXQUFXLElBQUksWUFBWSxFQUFFLHFCQUFxQixJQUFJLHNCQUFzQixFQUFFLGtDQUFrQyxJQUFJLG1DQUFtQyxFQUFDLE1BQU0saUJBQWlCLENBQUM7QUFDcFEsT0FBTyxFQUFDLG1CQUFtQixJQUFJLG9CQUFvQixFQUFDLE1BQU0sK0NBQStDLENBQUM7QUFDMUcsT0FBTyxFQUFDLG1CQUFtQixJQUFJLG9CQUFvQixFQUFDLE1BQU0sK0NBQStDLENBQUM7QUFDMUcsT0FBTyxFQUFDLDhCQUE4QixJQUFJLCtCQUErQixFQUFFLG1CQUFtQixJQUFJLG9CQUFvQixFQUFFLGtCQUFrQixJQUFJLG1CQUFtQixFQUFDLE1BQU0sUUFBUSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5leHBvcnQge2NyZWF0ZUVuZ2luZSBhcyDJtWNyZWF0ZUVuZ2luZX0gZnJvbSAnLi9jcmVhdGVfZW5naW5lJztcbmV4cG9ydCB7QW5pbWF0aW9uIGFzIMm1QW5pbWF0aW9ufSBmcm9tICcuL2RzbC9hbmltYXRpb24nO1xuZXhwb3J0IHtBbmltYXRpb25TdHlsZU5vcm1hbGl6ZXIgYXMgybVBbmltYXRpb25TdHlsZU5vcm1hbGl6ZXIsIE5vb3BBbmltYXRpb25TdHlsZU5vcm1hbGl6ZXIgYXMgybVOb29wQW5pbWF0aW9uU3R5bGVOb3JtYWxpemVyfSBmcm9tICcuL2RzbC9zdHlsZV9ub3JtYWxpemF0aW9uL2FuaW1hdGlvbl9zdHlsZV9ub3JtYWxpemVyJztcbmV4cG9ydCB7V2ViQW5pbWF0aW9uc1N0eWxlTm9ybWFsaXplciBhcyDJtVdlYkFuaW1hdGlvbnNTdHlsZU5vcm1hbGl6ZXJ9IGZyb20gJy4vZHNsL3N0eWxlX25vcm1hbGl6YXRpb24vd2ViX2FuaW1hdGlvbnNfc3R5bGVfbm9ybWFsaXplcic7XG5leHBvcnQge0FuaW1hdGlvbkVuZ2luZSBhcyDJtUFuaW1hdGlvbkVuZ2luZX0gZnJvbSAnLi9yZW5kZXIvYW5pbWF0aW9uX2VuZ2luZV9uZXh0JztcbmV4cG9ydCB7QW5pbWF0aW9uUmVuZGVyZXJGYWN0b3J5IGFzIMm1QW5pbWF0aW9uUmVuZGVyZXJGYWN0b3J5fSBmcm9tICcuL3JlbmRlci9hbmltYXRpb25fcmVuZGVyZXInO1xuZXhwb3J0IHtBbmltYXRpb25SZW5kZXJlciBhcyDJtUFuaW1hdGlvblJlbmRlcmVyLCBCYXNlQW5pbWF0aW9uUmVuZGVyZXIgYXMgybVCYXNlQW5pbWF0aW9uUmVuZGVyZXJ9IGZyb20gJy4vcmVuZGVyL3JlbmRlcmVyJztcbmV4cG9ydCB7Y29udGFpbnNFbGVtZW50IGFzIMm1Y29udGFpbnNFbGVtZW50LCBnZXRQYXJlbnRFbGVtZW50IGFzIMm1Z2V0UGFyZW50RWxlbWVudCwgaW52b2tlUXVlcnkgYXMgybVpbnZva2VRdWVyeSwgdmFsaWRhdGVTdHlsZVByb3BlcnR5IGFzIMm1dmFsaWRhdGVTdHlsZVByb3BlcnR5LCB2YWxpZGF0ZVdlYkFuaW1hdGFibGVTdHlsZVByb3BlcnR5IGFzIMm1dmFsaWRhdGVXZWJBbmltYXRhYmxlU3R5bGVQcm9wZXJ0eX0gZnJvbSAnLi9yZW5kZXIvc2hhcmVkJztcbmV4cG9ydCB7V2ViQW5pbWF0aW9uc0RyaXZlciBhcyDJtVdlYkFuaW1hdGlvbnNEcml2ZXJ9IGZyb20gJy4vcmVuZGVyL3dlYl9hbmltYXRpb25zL3dlYl9hbmltYXRpb25zX2RyaXZlcic7XG5leHBvcnQge1dlYkFuaW1hdGlvbnNQbGF5ZXIgYXMgybVXZWJBbmltYXRpb25zUGxheWVyfSBmcm9tICcuL3JlbmRlci93ZWJfYW5pbWF0aW9ucy93ZWJfYW5pbWF0aW9uc19wbGF5ZXInO1xuZXhwb3J0IHthbGxvd1ByZXZpb3VzUGxheWVyU3R5bGVzTWVyZ2UgYXMgybVhbGxvd1ByZXZpb3VzUGxheWVyU3R5bGVzTWVyZ2UsIGNhbWVsQ2FzZVRvRGFzaENhc2UgYXMgybVjYW1lbENhc2VUb0Rhc2hDYXNlLCBub3JtYWxpemVLZXlmcmFtZXMgYXMgybVub3JtYWxpemVLZXlmcmFtZXN9IGZyb20gJy4vdXRpbCc7XG4iXX0=