/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { NoopAnimationStyleNormalizer } from './dsl/style_normalization/animation_style_normalizer';
import { WebAnimationsStyleNormalizer } from './dsl/style_normalization/web_animations_style_normalizer';
import { NoopAnimationDriver } from './render/animation_driver';
import { AnimationEngine } from './render/animation_engine_next';
import { WebAnimationsDriver } from './render/web_animations/web_animations_driver';
export function createEngine(type, doc) {
    // TODO: find a way to make this tree shakable.
    if (type === 'noop') {
        return new AnimationEngine(doc, new NoopAnimationDriver(), new NoopAnimationStyleNormalizer());
    }
    return new AnimationEngine(doc, new WebAnimationsDriver(), new WebAnimationsStyleNormalizer());
}
//# sourceMappingURL=data:application/json;base64,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